/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.gui;

import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.gui.LockableSlot;
import com.flanks255.simplybackpacks.gui.SBContainerSlot;
import com.flanks255.simplybackpacks.items.Backpack;
import com.flanks255.simplybackpacks.util.BackpackUtils;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SBContainer
extends AbstractContainerMenu {
    public final IItemHandler handler;
    private final Backpack tier;
    private final UUID uuid;

    public static SBContainer fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        UUID uuidIn = data.m_130259_();
        Backpack tier = Backpack.values()[data.readInt()];
        return new SBContainer(windowId, playerInventory, uuidIn, tier, (IItemHandler)new ItemStackHandler(tier.slots));
    }

    public SBContainer(int windowId, Inventory playerInventory, UUID uuidIn, Backpack tierIn, IItemHandler handler) {
        super((MenuType)SimplyBackpacks.SBCONTAINER.get(), windowId);
        this.uuid = uuidIn;
        this.handler = handler;
        this.tier = tierIn;
        this.addPlayerSlots(playerInventory);
        this.addMySlots();
    }

    public Backpack getTier() {
        return this.tier;
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        return true;
    }

    @Nonnull
    public void m_150399_(int slot, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull Player player) {
        if (clickTypeIn == ClickType.SWAP) {
            return;
        }
        if (slot >= 0) {
            this.m_38853_((int)slot).f_40218_.m_6596_();
        }
        super.m_150399_(slot, dragType, clickTypeIn, player);
    }

    private void addPlayerSlots(Inventory playerInventory) {
        int originX = this.tier.slotXOffset;
        int originY = this.tier.slotYOffset;
        for (int col = 0; col < 9; ++col) {
            int x = originX + col * 18;
            int y = originY + 58;
            Optional<UUID> uuidOptional = BackpackUtils.getUUID((ItemStack)playerInventory.f_35974_.get(col));
            boolean lockMe = uuidOptional.map(id -> id.compareTo(this.uuid) == 0).orElse(false);
            this.m_38897_(new LockableSlot(playerInventory, col, x + 1, y + 1, lockMe));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = originX + col * 18;
                int y = originY + row * 18;
                int index = col + row * 9 + 9;
                Optional<UUID> uuidOptional = BackpackUtils.getUUID((ItemStack)playerInventory.f_35974_.get(index));
                boolean lockMe = uuidOptional.map(id -> id.compareTo(this.uuid) == 0).orElse(false);
                this.m_38897_(new LockableSlot(playerInventory, index, x + 1, y + 1, lockMe));
            }
        }
    }

    private void addMySlots() {
        if (this.handler == null) {
            return;
        }
        int cols = this.tier.slotCols;
        int rows = this.tier.slotRows;
        int slot_index = 0;
        block0: for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int x = 7 + col * 18;
                int y = 17 + row * 18;
                if (row > 7 && col > 2 && col < 13 && this.tier == Backpack.ULTIMATE) continue;
                this.m_38897_((Slot)new SBContainerSlot(this.handler, slot_index, x + 1, y + 1));
                if (++slot_index >= this.tier.slots) continue block0;
            }
        }
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            int bagslotcount = this.f_38839_.size();
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < playerIn.m_150109_().f_35974_.size() ? !this.m_38903_(itemstack1, playerIn.m_150109_().f_35974_.size(), bagslotcount, false) : !this.m_38903_(itemstack1, 0, playerIn.m_150109_().f_35974_.size(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }
}

